---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-Stage Detail（ステージ詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **stagepage.jsの動的レンダリング詳細**：JavaScript側の処理は間接的な確認のみ

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` （StagePageクラス全体、ApiHelper含む）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` （StagesTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.4の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.4の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /stages/stage/?id={stageId}&attempt={attemptId} | E-01 (36行目: WebUIPage("stage")) | ○ |
| C-02 | idとattemptパラメータが必須 | E-01 (84-88行目: require文) | ○ |
| C-03 | ステージデータはstageAttempt()で取得 | E-01 (109-110行目) | ○ |
| C-04 | ステージが存在しない場合エラーメッセージ表示 | E-01 (112-117行目) | ○ |
| C-05 | totalTasksが0の場合"No tasks have started yet"表示 | E-01 (123-130行目) | ○ |
| C-06 | ローカリティサマリーを表示 | E-01 (119行目: store.localitySummary, 162行目: サマリー内表示) | ○ |
| C-07 | ローカリティは4種類（Process local/Node local/Rack local/Any） | E-01 (70-74行目: names Map) | ○ |
| C-08 | Input/Output/Shuffle/Spillは条件付きで表示 | E-01 (164-199行目: hasInput/hasOutput/hasShuffleRead/hasShuffleWrite/hasBytesSpilled) | ○ |
| C-09 | 関連ジョブIDがリンク付きで表示される | E-01 (200-209行目: stageJobIds.sorted.map) | ○ |
| C-10 | DAG可視化はoperationGraphForStageで取得 | E-01 (213行目) | ○ |
| C-11 | タイムラインはUI_TIMELINE_ENABLEDで制御 | E-01 (39行目: TIMELINE_ENABLED, 260行目: if (!TIMELINE_ENABLED)) | ○ |
| C-12 | タイムラインは7種類の時間内訳で色分け | E-01 (45-51行目: TIMELINE_LEGEND) | ○ |
| C-13 | タスクタイムラインはページング対応 | E-01 (94-98行目: eventTimelineTaskPage/PageSize) | ○ |
| C-14 | タスクテーブルはstagepage.jsで動的レンダリング | E-01 (241-243行目: script src=stagepage.js) | ○ |
| C-15 | threadDumpEnabled設定がJavaScriptに渡される | E-01 (220-223行目: setTaskThreadDumpEnabled) | ○ |
| C-16 | タスクソートデフォルトは"Index" | E-01 (100-102行目: getOrElse("Index")) | ○ |
| C-17 | タスクページサイズデフォルトは100 | E-01 (104行目: getOrElse(100)) | ○ |
| C-18 | SPARK-8705の実行時間0対応がある | E-01 (331-333行目: if totalExecutionTime == 0) | ○ |
| C-19 | タスク内訳にschedulerDelay, gettingResultTimeを計算 | E-01 (296-297行目: AppStatusUtils呼び出し) | ○ |
| C-20 | Executor別にタスクをグループ化 | E-01 (391-399行目: groupArrayStr) | ○ |
| C-21 | drawTaskAssignmentTimeline関数を呼び出す | E-01 (451-453行目) | ○ |
| C-22 | タイムラインの最大タスク数はUI_TIMELINE_TASKS_MAXIMUM | E-01 (67行目: MAX_TIMELINE_TASKS) | ○ |
| C-23 | カラムヘッダーは22種類定義 | E-01 (461-486行目: HEADER_*定数) | ○ |
| C-24 | COLUMN_TO_INDEXでKVStoreインデックスにマッピング | E-01 (488-516行目) | ○ |
| C-25 | showVisualization=trueでDAG表示 | E-01 (245行目) | ○ |
| C-26 | useDataTables=trueでDataTablesライブラリ使用 | E-01 (246行目) | ○ |
| C-27 | Resource Profile IDを表示 | E-01 (153-155行目: stageData.resourceProfileId) | ○ |
| C-28 | stagepage.jsのSummary Metricsテーブル表示の詳細カラム | **根拠不足**（JavaScript側の直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- stagepage.jsの動的テーブルカラム構成とSummary Metricsの詳細
  - 候補：`core/src/main/resources/org/apache/spark/ui/static/stagepage.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドの処理フローは完全に確認済み
- 1: 中リスク - JavaScript側の動的レンダリング詳細は間接確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] タイムラインの時間内訳計算ロジックが正確か確認
- [ ] ローカリティレベルの種類が正しいか確認
- [ ] stagepage.jsのテーブルカラムがApiHelperの定義と一致しているか確認
- [ ] SPARK-8705の特殊処理が正確に記載されているか確認
